#ifndef _DOACCEPT_CPP
#define _DOACCEPT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <MSTcpIP.h>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::DoAccept(void)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::DoAccept.\n");
    #endif

	if(FD_ISSET(sckcListenSocket, &ReadFDS))
	{
		int iClient = 0;
		int iLength = 0;
		SOCKET sckLocalSocket = 0;

		SOCKADDR_IN RemoteClientSocketAddress;

		iLength = sizeof(SOCKADDR);
		if((sckLocalSocket = accept(sckcListenSocket, (SOCKADDR*)&RemoteClientSocketAddress, &iLength)) == SOCKET_ERROR)
		{
            printf("CSockSrvr::DoAccept : accept returned SOCKET_ERROR\n");
			return false;
		}

		if(sckLocalSocket == 0)
		{
            printf("CSockSrvr::DoAccept : accept returned 0\n");
			return false;
		}

		if(icCurrentClients == icMaxClients)
		{
            printf("CSockSrvr::DoAccept : Accept Failed. Too Many Clients.\n");

			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
			return false;
		}

		if((iClient = GetFreeSocketSlot()) == -1)
		{
            printf("CSockSrvr::DoAccept : Accept Failed. Not Enough Resources.\n");
			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
			return false;
		}

		bcWasConnect[iClient] = false;

		if(!OnAcceptConnectClient(iClient))
        {
            printf("CSockSrvr::DoAccept : Accept Failed. OnAcceptConnectClient returned false.\n");
			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
        }

		if(!Events.OnAccept(this, iClient))
		{
			printf("CSockSrvr::DoAccept : Accept Failed. OnAccept returned false.\n");
			WSASendDisconnect(sckLocalSocket, NULL);
			shutdown(sckLocalSocket, SD_BOTH);
			closesocket(sckLocalSocket);
		}

        icClientID[iClient] = icNextClientID++;
		bcConnected[iClient] = true;
		bcDisconnect[iClient] = false;
		sckcSocket[iClient] = sckLocalSocket;

		char sIP[100];
		sprintf(sIP, "Connection from [%s:%d]. Class ID: %d.", inet_ntoa(RemoteClientSocketAddress.sin_addr), ntohs(RemoteClientSocketAddress.sin_port), iClient);
		WriteLog(icClientID[iClient], sIP);

		icCurrentClients++;

        return Start_ClientThread(iClient);
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

